local twirledLines={}
local leftdragons={}
local twirledImage
local twirledYPosition=0
local twirledSpeed=-100
local twirledXOffset=200
local dragonsImage
local dragonsYPosition=-1595
local dragonsSpeed=60
local dragonsXOffset=9
local dragonsBgImage
function twirledLines.load()
twirledImage=love.graphics.newImage("twirledlines.png")
dragonsImage=love.graphics.newImage("leftdragons.png")
dragonsBgImage=love.graphics.newImage("leftdragonsbg.png")
end
function twirledLines.update(dt)
twirledYPosition=twirledYPosition+twirledSpeed*dt
if twirledYPosition<=-twirledImage:getHeight() then
twirledYPosition=twirledYPosition%twirledImage:getHeight()
end
dragonsYPosition=dragonsYPosition+dragonsSpeed*dt
if dragonsYPosition>=0 then
dragonsYPosition=dragonsYPosition%dragonsImage:getHeight()-dragonsImage:getHeight()
end end
function twirledLines.draw()
local screenHeight=love.graphics.getHeight()
local dragonsBgHeight=dragonsBgImage:getHeight()
for i=0,math.ceil(screenHeight/dragonsBgHeight) do
love.graphics.draw(dragonsBgImage,0,i*dragonsBgHeight)
end
local twirledImageHeight=twirledImage:getHeight()
for i=-1,math.ceil(screenHeight/twirledImageHeight) do
love.graphics.draw(twirledImage,twirledXOffset,twirledYPosition+i*twirledImageHeight)
end
local dragonsImageHeight=dragonsImage:getHeight()
for i=-1,math.ceil(screenHeight/dragonsImageHeight) do
love.graphics.draw(dragonsImage,dragonsXOffset,dragonsYPosition+i*dragonsImageHeight)
end end
return twirledLines
